<?php
$mysqli = new mysqli("localhost", "root", "", "persewaan_db");

if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Pastikan tabel 'persewaan_kendaraan' ada
$result = $mysqli->query("SELECT * FROM persewaan_kendaraan");

$items = [];
if ($result && $result->num_rows > 0) {
    $items = $result->fetch_all(MYSQLI_ASSOC);
} elseif (!$result) {
    die("Terjadi kesalahan dalam mengambil data: " . $mysqli->error);
}

$mysqli->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Persewaan Kendaraan</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1>Data Persewaan Kendaraan</h1>
            <nav>
                <a href="index.php" class="nav-link">Beranda</a>
                <a href="create.php" class="nav-link">Tambah Data</a>
                <a href="profile.php" class="nav-link">Profil Usaha</a>
            </nav>
        </div>
    </header>

    <main>
        <div class="data-table-container">
            <h2 class="table-title">List Persewaan</h2>
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Plat Nomor</th>
                        <th>Jenis Kendaraan</th>
                        <th>Harga Sewa</th>
                        <th>Durasi</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($items)): ?>
                        <?php foreach ($items as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['id']); ?></td>
                                <td><?= htmlspecialchars($row['plat_nomor']); ?></td>
                                <td><?= htmlspecialchars($row['jenis_kendaraan']); ?></td>
                                <td>Rp <?= number_format(htmlspecialchars($row['harga_sewa']), 0, ',', '.'); ?></td>
                                <td><?= htmlspecialchars($row['durasi']); ?> hari</td>
                                <td>
                                    <a href="edit.php?id=<?= htmlspecialchars($row['id']); ?>" class="btn-action">Edit</a> |
                                    <a href="delete.php?id=<?= htmlspecialchars($row['id']); ?>" class="btn-action delete-link">Hapus</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="6" style="text-align: center;">Tidak ada data.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </main>

    <footer>
        <p>&copy; 2024 Data Persewaan.Qian.</p>
    </footer>

    <script src="script.js"></script>
</body>
</html>
