<?php
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Koneksi ke database
$mysqli = new mysqli("localhost", "root", "", "persewaan_db");

if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Ambil data dari tabel persewaan_kendaraan
$query = "SELECT * FROM persewaan_kendaraan";
$result = $mysqli->query($query);

$items = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $items[] = $row;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'];
    $plat_nomor = $_POST['plat_nomor'];
    $jenis_kendaraan = $_POST['jenis_kendaraan'];
    $harga_sewa = $_POST['harga_sewa'];
    $durasi = $_POST['durasi'];

    $stmt = $mysqli->prepare("UPDATE persewaan_kendaraan SET plat_nomor = ?, jenis_kendaraan = ?, harga_sewa = ?, durasi = ? WHERE id = ?");
    $stmt->bind_param("ssisi", $plat_nomor, $jenis_kendaraan, $harga_sewa, $durasi, $id);

    if ($stmt->execute()) {
        echo "Data berhasil diperbarui.";
        // header("Location: index.php");
    } else {
        echo "Terjadi kesalahan: " . $stmt->error;
    }

    $stmt->close();
}

$mysqli->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Persewaan Kendaraan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1>Data Persewaan Kendaraan</h1>
            <nav>
                <a href="index.php">Beranda</a>
                <a href="create.php">Tambah Data</a>
                <a href="profile.php">Profil Usaha</a>
            </nav>
        </div>
    </header>

    <main>
        <h1 style="text-align: center;">List Persewaan Kendaraan</h1>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Plat Nomor</th>
                    <th>Jenis Kendaraan</th>
                    <th>Harga Sewa</th>
                    <th>Durasi</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($items)): ?>
                    <?php foreach ($items as $row): ?>
                        <tr>
                            <td><?= htmlspecialchars($row['id']); ?></td>
                            <td><?= htmlspecialchars($row['plat_nomor']); ?></td>
                            <td><?= htmlspecialchars($row['jenis_kendaraan']); ?></td>
                            <td>Rp <?= number_format(htmlspecialchars($row['harga_sewa']), 0, ',', '.'); ?></td>
                            <td><?= htmlspecialchars($row['durasi']); ?> hari</td>
                            <td>
                                <a href="edit.php?id=<?= htmlspecialchars($row['id']); ?>" class="btn-action">Edit</a> |
                                <a href="delete.php?id=<?= htmlspecialchars($row['id']); ?>" class="btn-action delete-link">Hapus</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="6" style="text-align: center;">Tidak ada data.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </main>
</body>
</html>
